import sys
import json
from urllib.parse import urljoin
import xbmcgui
import xbmcplugin
import requests
from bs4 import BeautifulSoup
try:
    from .plugin2 import m
except ImportError:
    from plugin2 import m

BASE_URL = 'https://doomovies.net'
USER_AGENT = 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/89.0.4389.90 Safari/537.36'
HEADERS = {"User-Agent": USER_AGENT, "Referer": BASE_URL}
SEARCH_URL = f'{BASE_URL}/?s='
SESSION = requests.sessions.Session()
CATEGORIES = {
    "New Movies": "https://doomovies.net/release/2023/",
    "Action": "https://doomovies.net/genre/action/",
    "Action & Adventure": "https://doomovies.net/genre/action-adventure/",
    "Adventure": "https://doomovies.net/genre/adventure/",
    "Animation": "https://doomovies.net/genre/animation/",
    "Biography": "https://doomovies.net/genre/biography/",
    "Comedy": "https://doomovies.net/genre/comedy/",
    "Crime": "https://doomovies.net/genre/crime/",
    "Documentary": "https://doomovies.net/genre/documentary/",
    "Drama": "https://doomovies.net/genre/drama/",
    "Family": "https://doomovies.net/genre/family/",
    "Fantasy": "https://doomovies.net/genre/fantasy/",
    "Featured": "https://doomovies.net/genre/featured/",
    "History": "https://doomovies.net/genre/history/",
    "Horror": "https://doomovies.net/genre/horror/",
    "Kids": "https://doomovies.net/genre/kids/",
    "Music": "https://doomovies.net/genre/music/",
    "Musical": "https://doomovies.net/genre/musical/",
    "Mystery": "https://doomovies.net/genre/mystery/",
    "News": "https://doomovies.net/genre/news/",
    "Reality": "https://doomovies.net/genre/reality/",
    "Romance": "https://doomovies.net/genre/romance/",
    "Sci-Fi & Fantasy": "https://doomovies.net/genre/sci-fi-fantasy/",
    "Science Fiction": "https://doomovies.net/genre/science-fiction/",
    "Short": "https://doomovies.net/genre/short/",
    "Sport": "https://doomovies.net/genre/sport/",
    "Thriller": "https://doomovies.net/genre/thriller/",
    "TV Movie": "https://doomovies.net/genre/tv-movie/",
    "TV Special": "https://doomovies.net/genre/tv-special/",
    "WWE": "https://doomovies.net/genre/wwe/",
    "War": "https://doomovies.net/genre/war/",
    "War & Politics": "https://doomovies.net/genre/war-politics/",
    "Western": "https://doomovies.net/genre/western/"
}

def get_page(url: str, referer: str = '') -> str:
    if referer:
        HEADERS['Referer'] = referer
    return SESSION.get(url, headers=HEADERS).text

def get_soup(url: str, referer: str = '') -> BeautifulSoup:
    response = get_page(url, referer)
    return BeautifulSoup(response, 'html.parser')

def search_shows():
    query = input('Enter Search Query: ')
    if not query:
        quit()
    
def main():
    sub_menu(CATEGORIES['New Movies'])

def sub_menu(url: str):
    if not '/page/' in url:
        url = urljoin(url, 'page/1')
    soup = get_soup(url)
    movies = soup.find_all(class_='item movies')
    for movie in movies:
        title = movie.h3.a.text
        link = movie.h3.a['href']
        thumbnail = movie.img['src']
        quality = movie.span.text
        title = f'{title} ({quality})'
        m.add_dir(title, link, 'doo_links', thumbnail, m.addon_fanart, title, isFolder=False)
    pages = []
    pagination = soup.find(class_='pagination')
    if pagination:
        for a in pagination.find_all('a'):
            if a.text and a.text not in pages:
                pages.append(a.text)
                title = a.text
                link = a['href']
                m.add_dir(f'Page {title}', link, 'doo_submenu', m.addon_icon, m.addon_fanart, f'Page {title}')

def imdb_search(imdb: str):
    links = []
    url = f'{SEARCH_URL}{imdb}'
    soup = get_soup(url)
    _title = soup.find(class_='title')
    title = _title.a.text
    link = _title.a['href']
    thumbnail = soup.find(class_='thumbnail').img['src']
    _ids = []
    soup2 = get_soup(link)
    for dooplay in soup2.find_all(class_='dooplay_player_option'):
        _id = dooplay['data-post']
        if _id not in _ids:
            _ids.append(_id)
    for _id in _ids:
        url1 = f'https://doomovies.net/wp-json/dooplayer/v2/{_id}/movie/1'
        page = json.loads(get_page(url1))
        url2 = page.get('embed_url')
        soup3 = get_soup(url2)
        link2 = soup3.find(attrs={'name': 'og:url'}).get('content')
        if link2:
            if not link2 in links:
                links.append(link2)

def get_links(title: str, url: str, thumbnail: str):
    links = []
    _ids = []
    soup2 = get_soup(url)
    for dooplay in soup2.find_all(class_='dooplay_player_option'):
        _id = dooplay['data-post']
        if _id not in _ids:
            _ids.append(_id)
    for _id in _ids:
        url1 = f'https://doomovies.net/wp-json/dooplayer/v2/{_id}/movie/1'
        page = json.loads(get_page(url1))
        url2 = page.get('embed_url')
        soup3 = get_soup(url2)
        link2 = soup3.find(attrs={'name': 'og:url'}).get('content')
        if link2:
            if not link2 in links:
                links.append(link2)
            return True

def get_links2(url: str):
    links = []
    _ids = []
    soup = get_soup(url)
    for dooplay in soup.find_all(class_='dooplay_player_option'):
        play_num = dooplay['data-nume']
        label = dooplay.span.text
        if label in ['VOE', 'RUBY']:
            _id = dooplay['data-post']
            link = f'https://doomovies.net/wp-json/dooplayer/v2/{_id}/movie/{play_num}'
            links.append([label, link])
    tbody = soup.find('tbody')
    if tbody:
        for tr in tbody.find_all('tr'):
            if 'English' in str(tr):
                label = tr.a.text
                link = tr.a['href']
                links.append([label, link])
    return links

def play_video(title, url, thumbnail):
    links = get_links2(url)
    link = m.get_multilink(links)
    if not link:
        sys.exit()
    if 'dooplayer' in link:
        page = SESSION.get(link, headers=HEADERS).json()
        url2 = page.get('embed_url')
        if 'imdb' in url2:
            link = url2
        elif 'rubystream' in url2:
            link = url2
        else:
            soup3 = get_soup(url2)
            link = soup3.find('media-player')
            if link:
                link = link.get('src')
    else:
        link = requests.get(link, headers=HEADERS).url
    if not link:
        sys.exit()
    import resolveurl
    if resolveurl.HostedMediaFile(link).valid_url():
        link = resolveurl.HostedMediaFile(link).resolve()
    liz = xbmcgui.ListItem(title, path=link)
    liz.setInfo('video', {'title': title, 'plot':title})
    liz.setArt({'thumb': thumbnail, 'icon': thumbnail, 'poster': thumbnail})
    liz.setProperty('IsPlayable', 'true')
    xbmcplugin.setResolvedUrl(int(sys.argv[1]), False, liz)
    return True
  
            
def runner(p: dict):
    name = p.get('name', '')
    url = p.get('url', '')
    action = p.get('action')
    icon = p.get('icon', m.addon_icon)
    page = p.get('page', '')
    if page: page = int(page)
    
    m.set_content('movies')
    
    if action == 'doo_main':
        main()
    elif action == 'doo_submenu':
        sub_menu(url)
    elif action == 'doo_links':
        play_video(name, url, icon)
    m.end_directory()
